<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AcademicYear extends Model 
{

    protected $table = 'academic_years';
    public $timestamps = true;
    protected $fillable = array('name', 'education_system_id');

    public function educationSystem()
    {
        return $this->belongsTo('App\Models\EducationSystem');
    }

    public function subjects()
    {
        return $this->hasMany('App\Models\Subject', 'academic_year_id');
    }

}